document.getElementById('contact_form').addEventListener('submit', function(e) {
    let valid = true;
    const name = document.querySelector('input[name="name"]');
    const email = document.querySelector('input[name="email"]');
    const phone = document.querySelector('input[name="phone"]');
    const message = document.querySelector('textarea[name="message"]');

    // Clear previous error states
    [name, email, phone, message].forEach(field => {
        field.classList.remove('is-invalid');
    });

    // Name validation
    if (!name.value.trim()) {
        valid = false;
        name.classList.add('is-invalid');
    }

    // Email validation
    const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
    if (!emailRegex.test(email.value.trim())) {
        valid = false;
        email.classList.add('is-invalid');
    }

    // Phone validation
    const phoneRegex = /^\+?[\d\s-]{10,}$/;
    if (!phoneRegex.test(phone.value.trim())) {
        valid = false;
        phone.classList.add('is-invalid');
    }

    // Message validation
    if (!message.value.trim()) {
        valid = false;
        message.classList.add('is-invalid');
    }

    if (!valid) {
        e.preventDefault();
    }
}); 