<!-- Feature area start here -->
<section id="feature" class="feature-area pb-130">
    <style>
        .feature-area {
            background: linear-gradient(rgba(0, 0, 0, 0.7), rgba(0, 0, 0, 0.7)), url('../images/img1.jpeg');
            background-size: cover;
            background-position: center;
            background-attachment: fixed;
            padding: 80px 0;
            position: relative;
            color: white;
        }

        .feature__wrp {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 15px;
        }

        .feature__item {
            background: rgba(0, 0, 0, 0.5);
            padding: 30px;
            border-radius: 10px;
            transition: all 0.3s ease;
            margin: 15px;
            backdrop-filter: blur(5px);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        .feature__item:hover {
            transform: translateY(-10px);
            background: rgba(0, 0, 0, 0.7);
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2);
        }

        .feature__icon {
            margin-bottom: 20px;
        }

        .feature__icon svg path {
            fill: white;
        }

        .feature__content h4 {
            margin: 0 0 15px 0;
        }

        .feature__content h4 a {
            color: white;
            font-size: 24px;
            text-decoration: none;
            transition: color 0.3s ease;
        }

        .feature__content h4 a:hover {
            color: #4ecdc4;
        }

        .feature__content p {
            color: #ffffff;
            font-size: 16px;
            line-height: 1.6;
            margin-bottom: 20px;
            animation: fadeIn 1s ease forwards;
        }

        .arrow-btn {
            color: white;
            font-size: 20px;
            text-decoration: none;
            transition: all 0.3s ease;
            display: inline-block;
        }

        .arrow-btn:hover {
            transform: translateX(10px);
            color: #4ecdc4;
        }

        .feature__text {
            text-align: center;
            margin-top: 50px;
            overflow: hidden;
        }

        .feature__text span {
            font-size: 24px;
            font-weight: bold;
            display: inline-block;
            margin-bottom: 15px;
            position: relative;
            white-space: nowrap;
            animation: typing 3.5s steps(40, end);
        }

        .feature__text p {
            font-size: 18px;
            animation: fadeIn 1s ease;
            margin: 0;
        }

        .feature__text a {
            color: #4ecdc4;
            text-decoration: none;
            transition: color 0.3s ease;
        }

        .feature__text a:hover {
            color: #fff;
        }

        @keyframes typing {
            from { width: 0 }
            to { width: 100% }
        }

        @keyframes fadeIn {
            from { 
                opacity: 0; 
                transform: translateY(20px); 
            }
            to { 
                opacity: 1; 
                transform: translateY(0); 
            }
        }

        @media (max-width: 992px) {
            .feature__item {
                margin: 10px;
                padding: 20px;
            }

            .feature__content h4 a {
                font-size: 20px;
            }

            .feature__content p {
                font-size: 14px;
            }
        }

        @media (max-width: 768px) {
            .feature-area {
                padding: 40px 0;
            }

            .feature__text span {
                font-size: 20px;
            }

            .feature__text p {
                font-size: 16px;
            }

            .row {
                flex-direction: column;
            }

            .col-sm-6 {
                width: 100%;
            }
        }

        @media (max-width: 576px) {
            .feature__item {
                margin: 5px;
                padding: 15px;
            }

            .feature__content h4 a {
                font-size: 18px;
            }
        }
    </style>

    <div class="feature__wrp">
        <div class="row g-0">
            <!-- Feature Item 1 -->
            <div class="col-sm-6 col-lg-3">
                <div class="feature__item">
                    <div class="feature__icon">
                        <svg width="91" height="74" viewBox="0 0 91 74" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <!-- SVG path data -->
                        </svg>
                    </div>
                    <div class="feature__content">
                        <h4><a href="#" class="hover-link">Global Business Solutions</a></h4>
                        <p>We provide strategic global business solutions, enabling companies and professionals to expand, connect, and thrive in the international market.</p>
                    </div>
                    <a href="#" class="arrow-btn"><i class="fa-light fa-arrow-right"></i></a>
                </div>
            </div>

            <!-- Feature Item 2 -->
            <div class="col-sm-6 col-lg-3">
                <div class="feature__item">
                    <div class="feature__icon">
                        <svg width="91" height="74" viewBox="0 0 91 74" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <!-- SVG path data -->
                        </svg>
                    </div>
                    <div class="feature__content">
                        <h4><a href="#" class="hover-link">Global Business Excellence</a></h4>
                        <p>We provide innovative solutions that empower businesses and professionals to expand their reach, engage in international trade, and thrive in the global market.</p>
                    </div>
                    <a href="#" class="arrow-btn"><i class="fa-light fa-arrow-right"></i></a>
                </div>
            </div>

            <!-- Feature Item 3 -->
            <div class="col-sm-6 col-lg-3">
                <div class="feature__item">
                    <div class="feature__icon">
                        <svg width="72" height="74" viewBox="0 0 72 74" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <!-- SVG path data -->
                        </svg>
                    </div>
                    <div class="feature__content">
                        <h4><a href="#" class="hover-link">Global Investment Opportunities</a></h4>
                        <p>We connect businesses and professionals with international investment prospects, fostering growth and expansion in the global marketplace.</p>
                    </div>
                    <a href="#" class="arrow-btn"><i class="fa-light fa-arrow-right"></i></a>
                </div>
            </div>

            <!-- Feature Item 4 -->
            <div class="col-sm-6 col-lg-3">
                <div class="feature__item">
                    <div class="feature__icon">
                        <svg width="74" height="74" viewBox="0 0 74 74" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <!-- SVG path data -->
                        </svg>
                    </div>
                    <div class="feature__content">
                        <h4><a href="#" class="hover-link">Global Financial Strategies</a></h4>
                        <p>We provide expert financial insights and strategies to help businesses and professionals navigate international markets, optimize investments, and achieve sustainable growth.</p>
                    </div>
                    <a href="#" class="arrow-btn"><i class="fa-light fa-arrow-right"></i></a>
                </div>
            </div>
        </div>
    </div>

    <div class="container">
        <div class="feature__text wow fadeInUp mt-50" data-wow-delay="00ms" data-wow-duration="1500ms">
            <span>ACT NOW</span>
            <p>Explore global opportunities for business growth and networking. <a href="#">Looking to expand internationally?</a></p>
        </div>
    </div>
</section>
<!-- Feature area end here -->

<h2 style="
    font-size: 36px;
    color: white;
    text-align: center;
    margin: 0 auto;
    overflow: hidden;
    white-space: nowrap;
    border-right: 3px solid #4ecdc4;
    animation: typing 4s steps(40) infinite, blink-caret 0.75s step-end infinite;
">GTPCertificate Website</h2>

<style>
@keyframes typing {
    0%, 100% { 
        width: 0;
    }
    50%, 90% { 
        width: 100%;
    }
}

@keyframes blink-caret {
    from, to { border-color: transparent }
    50% { border-color: #4ecdc4 }
}

/* Responsive styles */
@media (max-width: 768px) {
    h2 {
        font-size: 28px !important;
    }
}

@media (max-width: 480px) {
    h2 {
        font-size: 24px !important;
    }
}
</style>
